
//
// To jest przykadowy kod z podrozdziau 19.5.1 Potencjalne problemy z zarzdzaniem zasobami ksiki
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include <iostream>
#include <stdexcept>
#include <vector>

using std::vector;

//------------------------------------------------------------------------------

namespace N1
{
    void suspicious(int s, int x)
    {
        int* q = new int[x]; // zajmowanie pamici
        int* p = new int[s]; // zajmowanie pamici
        // ...
        if (x) p = q;        // przestawienie p na inny obiekt
        // ...
        delete[] p;          // zwalnianie pamici
    }
}

//------------------------------------------------------------------------------

namespace N2
{
    void suspicious(int s, int x)
    {
        int* p = new int[s]; // zajmowanie pamici
        // ...
        if (x) return;
        // ...
        delete[] p;          // zwalnianie pamici
    }
}

//------------------------------------------------------------------------------

namespace N3
{
    void suspicious(int s, int x)
    {
        int* p = new int[s]; // zajmowanie pamici
        vector<int> v;
        // ...
        if (x) p[x] = v.at(x);
        // ...
        delete[] p;          // zwalnianie pamici
    }
}

//------------------------------------------------------------------------------

namespace N4
{
    void suspicious(int s, int x)
    {
        int* p = new int[s]; // zajmowanie pamici
        vector<int> v;
        // ...
        try {
            if (x) p[x] = v.at(x);
            // ...
        } catch (...) {      // przechwytywanie wszystkich wyjtkw
            delete[] p;      // zwalnianie pamici
            throw;           // ponowne zgoszenie wyjtku
        }
        // ...
        delete[] p;          // zwalnianie pamici
    }
}

//------------------------------------------------------------------------------

namespace N5
{
    void suspicious(vector<int>& v, int s)
    {
        int* p = new int[s];
        vector<int>v1;
        // ...
        int* q = new int[s];
        vector<double> v2;
        // ...
        delete[] p;
        delete[] q;
    }
}

//------------------------------------------------------------------------------

int main()
try
{
    vector<int> v(100);

    N1::suspicious(4,4);
    N2::suspicious(4,4);
    N3::suspicious(4,4);
    N4::suspicious(4,4);
    N5::suspicious(v,4);
}
catch (std::exception& e) {
    std::cerr << "Bd: " << e.what() << '\n'; 
    return 1;
}
catch (...) {
    std::cerr << "Ojej: nieznany wyjtek!\n"; 
    return 2;
}

//------------------------------------------------------------------------------
